% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_tt.R
\name{format_tt}
\alias{format_tt}
\title{Format columns of a data frame}
\usage{
format_tt(
  x,
  j = NULL,
  digits = getOption("digits"),
  num_fmt = "significant",
  num_zero = TRUE,
  num_suffix = FALSE,
  num_mark_big = "",
  num_mark_dec = getOption("OutDec", default = "."),
  date = "\%Y-\%m-\%d",
  bool = function(column) tools::toTitleCase(tolower(column)),
  other = as.character,
  markdown = FALSE,
  sprintf = NULL
)
}
\arguments{
\item{x}{A data frame or a vector to be formatted.}

\item{j}{Column indices where the styling should be applied. Can be a single value, a vector, or a Perl-style regular expression applied to column names of the original data frame. If \code{colspan} is used, \code{j} must be of length 1.}

\item{digits}{Number of significant digits or decimal places.}

\item{num_fmt}{The format for numeric values; one of 'significant', 'decimal', or 'scientific'.}

\item{num_zero}{Logical; if TRUE, trailing zeros are kept in "decimal" format (but not in "significant" format).}

\item{num_suffix}{Logical; if TRUE display short numbers with \code{digits} significant digits and K (thousands), M (millions), B (billions), or T (trillions) suffixes.}

\item{num_mark_big}{Character to use as a thousands separator.}

\item{num_mark_dec}{Decimal mark character. Default is the global option 'OutDec'.}

\item{date}{A string passed to the \code{format()} function, such as "\%Y-\%m-\%d". See the "Details" section in \code{?strptime}}

\item{bool}{A function to format logical columns. Defaults to title case.}

\item{other}{A function to format columns of other types. Defaults to \code{as.character()}.}

\item{markdown}{Logical; if TRUE, render markdown syntax in cells. Ex: \verb{_italicized text_} is properly italicized in HTML and LaTeX.}

\item{sprintf}{String passed to the \code{?sprintf} function to format numbers or interpolate strings with a user-defined pattern (similar to the \code{glue} package, but using Base R).}
}
\value{
A data frame with formatted columns.
}
\description{
This function formats the columns of a data frame based on the column type (logical, date, numeric).
It allows various formatting options like significant digits, decimal points, and scientific notation.
It also includes custom formatting for date and boolean values.
}
\examples{
dat <- data.frame(
  a = rnorm(3, mean = 10000),
  b = rnorm(3, 10000))
tab <- format_tt(dat,
 digits = 2,
 num_mark_dec = ",",
 num_mark_big = " ")
tt(tab)

}
