% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_plots.R
\name{draw_boxplot}
\alias{draw_boxplot}
\title{draw boxplot for expression}
\usage{
draw_boxplot(
  exp,
  group_list,
  method = "kruskal.test",
  sort = TRUE,
  drop = FALSE,
  width = 0.5,
  pvalue_cutoff = 0.05,
  xlab = "Gene",
  ylab = "Expression",
  grouplab = "Group",
  p.label = FALSE,
  add_error_bar = FALSE,
  color = c("#2874C5", "#f87669", "#e6b707", "#868686", "#66C2A5", "#FC8D62",
    "#8DA0CB", "#E78AC3", "#A6D854", "#FFD92F", "#E5C494", "#B3B3B3")
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{method}{one of kruskal.test,aov,t.test and wilcox.test}

\item{sort}{whether the boxplot will be sorted}

\item{drop}{whether to discard insignificant values}

\item{width}{width of boxplot and error bar}

\item{pvalue_cutoff}{if drop = TRUE,genes with p-values below the threshold will be drawn}

\item{xlab}{title of the x axis}

\item{ylab}{title of the y axis}

\item{grouplab}{title of group legend}

\item{p.label}{whether to show p value in the plot}

\item{add_error_bar}{whether to add error bar}

\item{color}{color vector}
}
\value{
a boxplot according to \code{exp} and grouped by \code{group}.
}
\description{
draw boxplot for expression
}
\examples{
draw_boxplot(t(iris[,1:4]),iris$Species)
exp <-  matrix(rnorm(60),nrow = 10)
colnames(exp) <- paste0("sample",1:6)
rownames(exp) <- paste0("gene",1:10)
exp[,4:6] = exp[,4:6] +10
exp[1:4,1:4]
group_list <- factor(rep(c("A","B"),each = 3))
draw_boxplot(exp,group_list)
draw_boxplot(exp,group_list,color = c("grey","red"))
}
\seealso{
\code{\link{draw_heatmap}};\code{\link{draw_volcano}};\code{\link{draw_venn}}
}
\author{
Xiaojie Sun
}
