% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/timmaBinary1.R
\name{timmaBinary1}
\alias{timmaBinary1}
\title{Predicting drug sensitivity with binary drug-target interaction data using modified maximization and minimization rules}
\usage{
timmaBinary1(drug_target_profile, sens, loo = TRUE)
}
\arguments{
\item{drug_target_profile}{the drug-target interaction data. See \code{\link{timma}}.}

\item{sens}{a drug sensitivity vector.}

\item{loo}{a logical value indicating whether to use the leave-one-out cross-validation in the model
selection process. By default, loo = TRUE.}
}
\value{
A list containing the following components:
\item{dummy}{the predicted efficacy for target combinations}
\item{error}{the prediction errors}
\item{prediction}{predicted drug sensitivity}
}
\description{
A function to predict the drug sensitivity with binary drug-target interaction data using the
modified maximization and minimization rules
}
\examples{
data(tyner_interaction_binary)
data(tyner_sensitivity)
results<-timmaBinary1(tyner_interaction_binary[, 1:6], tyner_sensitivity[,1])
}
\author{
Liye He \email{liye.he@helsinki.fi}
}

