% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-summarise_by_time.R
\name{summarise_by_time}
\alias{summarise_by_time}
\alias{summarize_by_time}
\title{Summarise (for Time Series Data)}
\usage{
summarise_by_time(
  .data,
  .date_var,
  .by = "day",
  ...,
  .type = c("floor", "ceiling", "round")
)

summarize_by_time(
  .data,
  .date_var,
  .by = "day",
  ...,
  .type = c("floor", "ceiling", "round")
)
}
\arguments{
\item{.data}{A \code{tbl} object or \code{data.frame}}

\item{.date_var}{A column containing date or date-time values to summarize.
If missing, attempts to auto-detect date column.}

\item{.by}{A time unit to summarise by.
Time units are collapsed using \code{lubridate::floor_date()} or \code{lubridate::ceiling_date()}.

The value can be:
\itemize{
\item \code{second}
\item \code{minute}
\item \code{hour}
\item \code{day}
\item \code{week}
\item \code{month}
\item \code{bimonth}
\item \code{quarter}
\item \code{season}
\item \code{halfyear}
\item \code{year}
}

Arbitrary unique English abbreviations as in the \code{lubridate::period()} constructor are allowed.}

\item{...}{Name-value pairs of summary functions.
The name will be the name of the variable in the result.

The value can be:
\itemize{
\item A vector of length 1, e.g. \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.
\item A vector of length \code{n}, e.g. \code{quantile()}.
\item A data frame, to add multiple columns from a single expression.
}}

\item{.type}{One of "floor", "ceiling", or "round. Defaults to "floor". See \code{lubridate::round_date}.}
}
\value{
A \code{tibble} or \code{data.frame}
}
\description{
\code{summarise_by_time()} is a time-based variant of the popular \code{dplyr::summarise()} function
that uses \code{.date_var} to specify a date or date-time column and \code{.by} to group the
calculation by groups like "5 seconds", "week", or "3 months".

\code{summarise_by_time()} and \code{summarize_by_time()} are synonyms.
}
\section{Useful summary functions}{

\itemize{
\item Sum: \code{\link[=sum]{sum()}}
\item Center: \code{\link[=mean]{mean()}}, \code{\link[=median]{median()}}
\item Spread: \code{\link[=sd]{sd()}}, \code{\link[=var]{var()}}
\item Range: \code{\link[=min]{min()}}, \code{\link[=max]{max()}}
\item Count: \code{dplyr::n()}, \code{dplyr::n_distinct()}
\item Position: \code{dplyr::first()}, \code{dplyr::last()}, \code{dplyr::nth()}
\item Correlation: \code{\link[=cor]{cor()}}, \code{\link[=cov]{cov()}}
}
}

\examples{
# Libraries
library(timetk)
library(dplyr)

# First value in each month
m4_daily \%>\%
    group_by(id) \%>\%
    summarise_by_time(
        .date_var = date,
        .by       = "month", # Setup for monthly aggregation
        # Summarization
        value  = first(value)
    )

# Last value in each month (day is first day of next month with ceiling option)
m4_daily \%>\%
    group_by(id) \%>\%
    summarise_by_time(
        .by        = "month",
        value      = last(value),
        .type      = "ceiling"
    ) \%>\%
    # Shift to the last day of the month
    mutate(date = date \%-time\% "1 day")

# Total each year (.by is set to "year" now)
m4_daily \%>\%
    group_by(id) \%>\%
    summarise_by_time(
        .by        = "year",
        value      = sum(value)
    )


}
\seealso{
Time-Based dplyr functions:
\itemize{
\item \code{\link[=summarise_by_time]{summarise_by_time()}} - Easily summarise using a date column.
\item \code{\link[=mutate_by_time]{mutate_by_time()}} - Simplifies applying mutations by time windows.
\item \code{\link[=filter_by_time]{filter_by_time()}} - Quickly filter using date ranges.
\item \code{\link[=filter_period]{filter_period()}} - Apply filtering expressions inside periods (windows)
\item \code{\link[=between_time]{between_time()}} - Range detection for date or date-time sequences.
\item \code{\link[=pad_by_time]{pad_by_time()}} - Insert time series rows with regularly spaced timestamps
\item \code{\link[=condense_period]{condense_period()}} - Convert to a different periodicity
\item \code{\link[=slidify]{slidify()}} - Turn any function into a sliding (rolling) function
}
}
