% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_whole_number.R
\name{is_whole_number}
\alias{is_whole_number}
\title{Are all numbers whole numbers?}
\usage{
is_whole_number(x, na.rm = TRUE, tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{Should \code{NA} values be removed before calculation?
Default is \code{TRUE}.}

\item{tol}{tolerance value such that a whole number satisfies the condition
\code{abs(round(x) - x) < tol}. \cr
The default is \code{sqrt(.Machine$double.eps)}.}
}
\value{
A logical vector of length 1.
}
\description{
Are all numbers whole numbers?
}
\details{
This is a very efficient function that returns \code{FALSE} if any number
is not a whole-number and \code{TRUE} if all of them are.

Inspired by the discussion in this thread:
\href{https://stackoverflow.com/questions/3476782/check-if-the-number-is-integer/76655734}{check-if-the-number-is-integer}
}
\examples{
library(timeplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
# Has built-in tolerance
sqrt(2)^2 \%\% 1 == 0
is_whole_number(sqrt(2)^2)

is_whole_number(1)
is_whole_number(1.2)

x1 <- c(0.02, 0:10^5)
x2 <- c(0:10^5, 0.02)

is_whole_number(x1)
is_whole_number(x2)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
