% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randOU.R
\name{randOU}
\alias{randOU}
\title{Draw from an Ornstein-Uhlenbeck process}
\usage{
randOU(
  mean = 0,
  sd = 1,
  gamma = 1,
  t = 0:1000/1000,
  yini = NA,
  yend = NA,
  log = FALSE
)
}
\arguments{
\item{mean}{asymptotic mean of the process.}

\item{sd}{asymptotic standard deviation of the process}

\item{gamma}{rate coefficient for return to the mean}

\item{t}{vector of time points at which the process should be sampled
(note: the value at t[1] will be the starting value yini,
the value at t[length(t)] the end value yend if these are specified)}

\item{yini}{start value of the process 
(NA indicates random with asymptotic mean and sd)}

\item{yend}{end value of the process 
(NA indicates no conditioning at the end)}

\item{log}{indicator whether the log of the variable should be an Ornstein-Uhlenbeck 
process (log=TRUE) rather than the variable itself
(mean and sd are interpreted in original units also for log=TRUE)}
}
\value{
a data frame with t and y columns for time and for the realization of the Ornstein-Uhlenbeck process
}
\description{
This function draws a realization of an Ornstein-Uhlenbeck process 
with a random start value (drawn from the marginal distribution),
conditional of the start value, or conditional on both start and end values.
The function includes the option of obtaining a lognormal marginal by 
exponential tranformation.
}
\examples{
plot(randOU(mean=0,sd=1,gamma=1,t=0:1000/1000),type="l",ylim=2.5*c(-1,1))
abline(h=0)
lines(randOU(mean=0,sd=1,gamma=1,t=0:1000/1000),col="red")
lines(randOU(mean=0,sd=1,gamma=1,t=0:1000/1000),col="blue")
lines(randOU(mean=0,sd=1,gamma=1,t=0:1000/1000),col="green")

plot(randOU(mean=0,sd=1,gamma=1,t=0:1000/1000,yini=0,yend=0),type="l",ylim=2.5*c(-1,1))
abline(h=0)
lines(randOU(mean=0,sd=1,gamma=1,t=0:1000/1000,yini=0,yend=0),col="red")
lines(randOU(mean=0,sd=1,gamma=1,t=0:1000/1000,yini=0,yend=0),col="blue")
lines(randOU(mean=0,sd=1,gamma=1,t=0:1000/1000,yini=0,yend=0),col="green")
}
