% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArraySchema.R
\name{attrs,tiledb_array_schema,numeric-method}
\alias{attrs,tiledb_array_schema,numeric-method}
\title{Returns a \code{tiledb_attr} object associated with the \code{tiledb_array_schema} with a given index}
\usage{
\S4method{attrs}{tiledb_array_schema,numeric}(object, idx, ...)
}
\arguments{
\item{object}{tiledb_array_schema}

\item{idx}{attribute index}

\item{...}{Extra parameter for method signature, currently unused.}
}
\value{
a \code{tiledb_attr} object
}
\description{
The attribute index is defined by the order the attributes were defined in the schema
}
\examples{
dom <- tiledb_domain(dims = c(tiledb_dim("d1", c(1L, 10L), type = "INT32")))
sch <- tiledb_array_schema(dom, attrs = c(tiledb_attr("a1", type = "INT32"),
                                               tiledb_attr("a2", type = "FLOAT64")))
attrs(sch, 2)

}
