% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landmarks.R
\name{landmarks}
\alias{landmarks}
\title{Download a point or area landmarks shapefile into R}
\usage{
landmarks(state, type = "point", year = NULL, ...)
}
\arguments{
\item{state}{The state for which you'd like to download the landmarks}

\item{type}{Whether you would like to download point landmarks (\code{"point"}) or area landmarks (\code{"area"}). #'                Defaults to \code{"point"}.}

\item{year}{the data year; defaults to 2022}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
Description from the US Census Bureau:
"The Census Bureau includes landmarks in the MAF/TIGER database (MTDB) for locating special features
and to help enumerators during field operations. Some of the more common landmark types include area
landmarks such as airports, cemeteries, parks, and educational facilities and point landmarks such as
schools and churches."
}
\details{
The Census Bureau adds landmark features to the database on an as-needed basis and makes no
attempt to ensure that all instances of a particular feature were included. The absence of a landmark
such as a hospital or prison does not mean that the living quarters associated with that landmark were
excluded from the 2010 Census enumeration. The landmarks were not used as the basis for building or
maintaining the address list used to conduct the 2010 Census.

Area landmark and area water features can overlap; for example, a park or other special land-use feature
may include a lake or pond. In this case, the polygon covered by the lake or pond belongs to a water
feature and a park landmark feature. Other kinds of landmarks can overlap as well. Area landmarks can
contain point landmarks, but these features are not linked in the TIGER/Line Shapefiles.

Landmarks may be identified by a MAF/TIGER feature class code only and may not have a name. Each
landmark has a unique area landmark identifier (AREAID) or point landmark identifier (POINTID) value.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
}
}

\seealso{
\url{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2020/TGRSHP2020_TechDoc_Ch3.pdf}
}
