% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water.R
\name{area_water}
\alias{area_water}
\title{Download an area water shapefile into R}
\usage{
area_water(state, county, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code of the state of the county you'd like to
download the water features for.  Can also be state name or abbreviation
(case-insensitive).}

\item{county}{The three-digit FIPS code of the county you'd like the water
features for.  Can also be a county name.}

\item{year}{the data year; defaults to 2020}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
From the US Census Bureau: "The area hydrography shapefile contains the geometry
and attributes of both perennial and intermittent
area hydrography features, including ponds, lakes, oceans, swamps, glaciers, and the area covered by
large streams represented as double-line drainage."
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
}
}

\examples{
\dontrun{
library(tigris)

dallas_water <- area_water("TX", "Dallas")

plot(dallas_water$geometry)

}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2020/TGRSHP2020_TechDoc.pdf}

Other water functions: 
\code{\link{coastline}()},
\code{\link{linear_water}()}
}
\concept{water functions}
