% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/native.R
\name{alaska_native_regional_corporations}
\alias{alaska_native_regional_corporations}
\title{Download an Alaska Native Regional Corporation shapefile into R.}
\usage{
alaska_native_regional_corporations(cb = FALSE, year = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{the data year; defaults to 2020}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
From the US Census Bureau: "ANRCs are corporations created according to the Alaska Native Claims Settlement Act.
They are organized under the laws of the State of
Alaska as "Regional Corporations," to conduct both the for-profit and non-profit affairs of Alaska Natives
within defined regions of Alaska."  For more information, please see the Census technical documentation at the
link provided.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
}
}

\seealso{
\url{https://www2.census.gov/geo/pdfs/reference/GARM/Ch5GARM.pdf}

Other native/tribal geometries functions: 
\code{\link{native_areas}()},
\code{\link{tribal_block_groups}()},
\code{\link{tribal_census_tracts}()},
\code{\link{tribal_subdivisions_national}()}
}
\concept{native/tribal geometries functions}
