% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/places.R
\name{places}
\alias{places}
\title{Download a Census-designated places shapefile into R}
\usage{
places(state, cb = FALSE, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state you want. Can also
be state name or state abbreviation.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
cartographic boundary file.  Defaults to FALSE (the most detailed
TIGER/Line file).}

\item{year}{the data year (defaults to 2015).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
Census Designated Places (CDPs) are the statistical counterparts of
incorporated places, and are delineated to provide data for settled
concentrations of population that are identifiable by name but are
not legally incorporated under the laws of the state in which they
are located.
}
\details{
The boundaries usually are defined in cooperation with local or tribal
officials and generally updated prior to each decennial census.

These boundaries, which usually coincide with visible features or the
boundary of an adjacent incorporated place or another legal entity boundary,
have no legal status, nor do these places have officials elected to serve
traditional municipal functions.

CDP boundaries may change from one decennial census to the next with changes
in the settlement pattern; a CDP with the same name as in an earlier census
does not necessarily have the same boundary.

CDPs must be contained within a single state and may not extend into an
incorporated place.

There are no population size requirements for CDPs.
}
\seealso{
\url{https://www.census.gov/geo/reference/gtc/gtc_place.html}

Other general area functions: \code{\link{block_groups}},
  \code{\link{blocks}}, \code{\link{counties}},
  \code{\link{county_subdivisions}}, \code{\link{pumas}},
  \code{\link{school_districts}}, \code{\link{states}},
  \code{\link{tracts}}, \code{\link{zctas}}
}
