% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_spat_coordinates.R
\name{stat_spat_coordinates}
\alias{stat_spat_coordinates}
\title{Extract coordinates from SpatVector objects}
\usage{
stat_spat_coordinates(
  mapping = aes(),
  data = NULL,
  geom = "point",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{A SpatVector object, see \code{\link[terra:vect]{terra::vect()}}.}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.

You can also set this to one of "polygon", "line", and "point" to
override the default legend.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:stat_sf_coordinates]{ggplot2::stat_sf_coordinates()}}.}
}
\value{
A ggplot2 layer
}
\description{
\code{stat_spat_coordinates()} extracts the coordinates from SpatVector objects
and summarises them to one pair of coordinates (x and y) per geometry.
}
\details{
Wrapper of \code{\link[ggplot2:stat_sf_coordinates]{ggplot2::stat_sf_coordinates()}}.

See \code{\link[ggplot2:stat_sf_coordinates]{ggplot2::stat_sf_coordinates()}} for details.
}
\examples{
\donttest{
cyl <- terra::vect(system.file("extdata/cyl.gpkg", package = "tidyterra"))

library(ggplot2)

ggplot(cyl) +
  stat_spat_coordinates()

ggplot(cyl) +
  geom_errorbarh(
    aes(
      geometry = geometry,
      xmin = after_stat(x) - 50000,
      xmax = after_stat(x) + 50000,
      y = after_stat(y),
      height = 10000
    ),
    stat = "sf_coordinates"
  )
}

}
\seealso{
Other ggplot2 utils:
\code{\link{autoplot.Spat}},
\code{\link{fortify.Spat}},
\code{\link{geom_spat_contour}},
\code{\link{geom_spatraster_rgb}()},
\code{\link{geom_spatraster}()},
\code{\link{ggspatvector}}
}
\concept{ggplot2.utils}
\keyword{internal}
