% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.Spat.R
\name{fortify.Spat}
\alias{fortify.Spat}
\alias{fortify.SpatRaster}
\alias{fortify.SpatVector}
\title{Fortify Spat* Objects}
\usage{
\method{fortify}{SpatRaster}(
  model,
  data,
  ...,
  .name_repair = "unique",
  maxcell = terra::ncell(model) * 1.1
)

\method{fortify}{SpatVector}(model, data, ...)
}
\arguments{
\item{model}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}} or a SpatVector
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{data}{Not used by this method.}

\item{...}{other arguments passed to methods}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence,
\item \code{"unique"}: Make sure names are unique and not empty,
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique},
\item \code{"universal"}: Make the names \code{unique} and syntactic
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base R).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}
}}

\item{maxcell}{positive integer. Maximum number of cells to use for the plot.}
}
\value{
\code{\link[=fortify.SpatVector]{fortify.SpatVector()}} returns a \code{sf} object and
\code{\link[=fortify.SpatRaster]{fortify.SpatRaster()}} returns a tibble. See \strong{Methods}.
}
\description{
Fortify SpatRasters and SpatVectors to data frames for compatibility with
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\section{Methods}{


Implementation of the \strong{generic} \code{\link[ggplot2:fortify]{ggplot2::fortify()}} function.
\subsection{SpatRaster}{

Return a tibble than can be used with \verb{ggplot2::geom_*} like
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}, \code{\link[ggplot2:geom_tile]{ggplot2::geom_raster()}}, etc.

The resulting tibble includes the coordinates on the columns \verb{x,y}. The
values of each layer are included as additional columns named as per the
name of the layer on the SpatRaster.

The CRS of the SpatRaster can be retrieved with
\verb{attr(<fortifiedSpatRaster>, "crs")}.

It is possible to convert the fortified object onto a SpatRaster again with
\code{\link[=as_spatraster]{as_spatraster()}}.
}

\subsection{SpatVector}{

Return a \code{sf} object than can be used with \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.
}
}

\examples{
\donttest{

# Get a SpatRaster
r <- system.file("extdata/volcano2.tif", package = "tidyterra") \%>\%
  terra::rast()

fortified <- ggplot2::fortify(r)

fortified

# The crs is an attribute of the fortified SpatRaster

attr(fortified, "crs")

# Back to a SpatRaster with
as_spatraster(fortified)

# You can now use a SpatRaster with raster, contours, etc.
library(ggplot2)

# Use here the raster with resample
ggplot(r, maxcell = 10000) +
  # Need the aes parameters
  geom_raster(aes(x, y, fill = elevation)) +
  # Adjust the coords
  coord_equal()

# Or any other geom
ggplot(r) +
  geom_histogram(aes(x = elevation), bins = 20, fill = "lightblue", color = "black")

# Create a SpatVector
extfile <- system.file("extdata/cyl.gpkg", package = "tidyterra")
cyl <- terra::vect(extfile)

cyl

# To sf
ggplot2::fortify(cyl)

# Now you can use geom_sf()

library(ggplot2)

ggplot(cyl) +
  geom_sf()
}

}
\seealso{
\code{\link[sf:st_as_sf]{sf::st_as_sf()}}, \link{as_tibble.Spat}, \code{\link[=as_spatraster]{as_spatraster()}},
\code{\link[ggplot2:fortify]{ggplot2::fortify()}}.

Other ggplot2 utils:
\code{\link{autoplot.Spat}},
\code{\link{geom_spat_contour}},
\code{\link{geom_spatraster_rgb}()},
\code{\link{geom_spatraster}()},
\code{\link{ggspatvector}},
\code{\link{stat_spat_coordinates}()}

Other ggplot2 methods:
\code{\link{autoplot.Spat}}

Coercing objects:
\code{\link{as_coordinates}()},
\code{\link{as_spatraster}()},
\code{\link{as_tibble.Spat}}
}
\concept{coerce}
\concept{ggplot2.methods}
\concept{ggplot2.utils}
