% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tibble.Spat.R
\name{as_tibble.Spat}
\alias{as_tibble.Spat}
\alias{as_tibble.SpatRaster}
\alias{as_tibble.SpatVector}
\title{Coerce a Spat* object to data frames}
\usage{
\method{as_tibble}{SpatRaster}(x, ..., xy = FALSE, na.rm = FALSE, .name_repair = "unique")

\method{as_tibble}{SpatVector}(x, ..., .name_repair = "unique")
}
\arguments{
\item{x}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}} or a SpatVector
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{...}{Arguments passed on to \code{\link[terra:as.data.frame]{terra::as.data.frame()}}}

\item{xy}{logical. If \code{TRUE}, the coordinates of each raster cell are included}

\item{na.rm}{logical. If \code{TRUE}, cells that have a NA value in at least one layer are removed. If the argument is set to \code{NA} only cells that have NA values in all layers are removed}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence,
\item \code{"unique"}: Make sure names are unique and not empty,
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique},
\item \code{"universal"}: Make the names \code{unique} and syntactic
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base R).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}
}}
}
\value{
A tibble.
}
\description{
\code{as_tibble()} method for SpatRaster and SpatVector.
}
\section{terra equivalent}{


\code{\link[terra:as.data.frame]{terra::as.data.frame()}}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[tibble:as_tibble]{tibble::as_tibble()}} function.
\subsection{SpatRaster}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}} The tibble is returned with an attribute
including the crs of the initial object in WKT format (see \code{\link[=pull_crs]{pull_crs()}}).
}
}

\section{About layer names}{


When coercing SpatRaster objects to data frames, \code{x} and \code{y} names are
reserved for geographic coordinates of each cell of the raster. It should be
also noted that terra allows layers with duplicated names.

In the process of coercing a SpatRaster to a tibble, tidyterra may rename
the layers of your SpatRaster for overcoming this issue. Specifically, layers
may be renamed on the following cases:
\itemize{
\item Layers with duplicated names
\item When coercing to a tibble, if \code{xy = TRUE}, layers named \code{x} or \code{y} would be
renamed.
\item When working with tidyverse methods (i.e. \code{\link[=filter.SpatRaster]{filter.SpatRaster()}}), the
latter would happen as well.
}

tidyterra would display a message informing of the changes on the names of
the layer.
}

\examples{

library(terra)
# SpatRaster
f <- system.file("extdata/cyl_temp.tif", package = "tidyterra")
r <- rast(f)

as_tibble(r, na.rm = TRUE)

as_tibble(r, xy = TRUE)

# SpatVector

f <- system.file("extdata/cyl.gpkg", package = "tidyterra")
v <- vect(f)

as_tibble(v)

}
\seealso{
\code{\link[tibble:as_tibble]{tibble::as_tibble()}}, \code{\link[terra:as.data.frame]{terra::as.data.frame()}}

Coercing objects:
\code{\link{as_coordinates}()},
\code{\link{as_spatraster}()},
\code{\link{fortify.Spat}}
}
\concept{coerce}
\concept{tibble.methods}
