% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-methods.R
\name{get_sq_lengths}
\alias{get_sq_lengths}
\title{Get lengths of sequences in sq object}
\usage{
get_sq_lengths(x)
}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}
}
\value{
A \code{\link{numeric}} vector, where each element gives length of
corresponding sequence from \code{\link[=sq-class]{sq}} object.
}
\description{
Returns number of elements in each sequence in given
\code{\link[=sq-class]{sq}} object.
}
\details{
Due to storage implementation, using \code{\link[base]{lengths}} method
returns length of stored raw vectors instead of real sequence lengths. This
function accesses \code{original_length} attribute of each sequence, which
attribute stores information about how many elements are there in given
sequence.
}
\examples{
# Creating objects to work on:
sq_ami <- sq(c("MIAANYTWIL","TIAALGNIIYRAIE", "NYERTGHLI", "MAYXXXIALN"),
             alphabet = "ami_ext")
sq_dna <- sq(c("ATGCAGGA", "GACCGAACGAN", "TGACGAGCTTA", "ACTNNAGCN"),
             alphabet = "dna_ext")

# Counting number of elements in sq object:
get_sq_lengths(sq_dna)
get_sq_lengths(sq_ami)

}
\seealso{
Functions from utility module:
\code{\link{==.sq}()},
\code{\link{is.sq}()},
\code{\link{sqconcatenate}},
\code{\link{sqextract}}
}
\concept{util_functions}
