% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R
\name{chop}
\alias{chop}
\alias{unchop}
\title{Chop and unchop}
\usage{
chop(data, cols)

unchop(data, cols, keep_empty = FALSE, ptype = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{cols}{Column to chop or unchop (automatically quoted).

This should be a list-column containing generalised vectors (e.g.
any mix of \code{NULL}s, atomic vector, S3 vectors, a lists, or data frames).}

\item{keep_empty}{By default, you get one row of output for each element
of the list your unchopping/unnesting. This means that if there's a
size-0 element (like \code{NULL} or an empty data frame), that entire row
will be dropped from the output. If you want to preserve all rows,
use \code{keep_empty = TRUE} to replace size-0 elements with a single row
of missing values.}

\item{ptype}{Optionally, supply a data frame prototype for the output \code{cols},
overriding the default that will be guessed from the combination of
individual values.}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}

Chopping and unchopping preserve the width of a data frame, changing its
length. \code{chop()} makes \code{df} shorter by converting rows within each group
into list-columns. \code{unchop()} makes \code{df} longer by expanding list-columns
so that each element of the list-column gets its own row in the output.
}
\details{
Generally, unchopping is more useful than chopping because it simplifies
a complex data structure, and \code{\link[=nest]{nest()}}ing is usually more appropriate
that \code{chop()}ing` since it better preserves the connections between
observations.
}
\examples{
# Chop ==============================================================
df <- tibble(x = c(1, 1, 1, 2, 2, 3), y = 1:6, z = 6:1)
# Note that we get one row of output for each unique combination of
# non-chopped variables
df \%>\% chop(c(y, z))
# cf nest
df \%>\% nest(data = c(y, z))

# Unchop ============================================================
df <- tibble(x = 1:4, y = list(integer(), 1L, 1:2, 1:3))
df \%>\% unchop(y)
df \%>\% unchop(y, keep_empty = TRUE)

# Incompatible types -------------------------------------------------
# If the list-col contains types that can not be natively
df <- tibble(x = 1:2, y = list("1", 1:3))
try(df \%>\% unchop(y))
df \%>\% unchop(y, ptype = tibble(y = integer()))
df \%>\% unchop(y, ptype = tibble(y = character()))
df \%>\% unchop(y, ptype = tibble(y = list()))

# Unchopping data frames -----------------------------------------------------
# Unchopping a list-col of data frames must generate a df-col because
# unchop leaves the column names unchanged
df <- tibble(x = 1:3, y = list(NULL, tibble(x = 1), tibble(y = 1:2)))
df \%>\% unchop(y)
df \%>\% unchop(y, keep_empty = TRUE)
}
