% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust.R
\name{adjust_legend_title}
\alias{adjust_legend_title}
\alias{adjust_legend_position}
\title{Adjust legend}
\usage{
adjust_legend_title(
  plot,
  title = ggplot2::waiver(),
  fontsize = NULL,
  family = NULL,
  face = NULL,
  color = "black",
  ...
)

adjust_legend_position(plot, position = "right")
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{title}{Legend title.}

\item{fontsize}{Font size in points. Defaults to \code{7}.}

\item{family}{The typeface to use. The validity of this value will depend on
the graphics device being used for rendering the plot. See
\href{https://systemfonts.r-lib.org/articles/systemfonts.html}{the systemfonts vignette}
for guidance on the best way to access fonts installed on your computer.
The values \code{"sans"}, \code{"serif"}, and \code{"mono"} should always be valid and
will select the default typeface for the respective styles. However, what
is considered default is dependant on the graphics device and the operating
system.}

\item{face}{Font face ("plain", "italic", "bold", "bold.italic")}

\item{color}{A hex color for the stroke color. For example, \code{"#FFFFFF"} for white.}

\item{...}{Arguments passed on to \code{ggplot2::element_text()}.}

\item{position}{The position of the legend. Can be one of
\code{c("right", "left", "bottom", "top", "none")}. Defaults to \code{"right"}.}
}
\value{
A \code{tidyplot} object.
}
\description{
Adjust legend
}
\details{
\itemize{
\item The \code{title} argument of \code{adjust_legend_title()} supports \href{https://www.rdocumentation.org/packages/grDevices/versions/3.6.2/topics/plotmath}{plotmath expressions} to include special characters.
See examples and \href{https://jbengler.github.io/tidyplots/articles/Advanced-plotting.html#special-characters}{Advanced plotting}.
}
}
\examples{
# Plot without adjustments
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# New title
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  adjust_legend_title("My new legend title")

# New title with plotmath expression
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  adjust_legend_title("$E==m*c^{2}$")

# Alternative legend positions
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  adjust_legend_position("left")

study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  adjust_legend_position("top")

study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  adjust_legend_position("bottom")

# `position = "none"` hides the legend
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  adjust_legend_position("none")

}
