% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{split_plot}
\alias{split_plot}
\title{Split plot into multiple subplots}
\usage{
split_plot(
  plot,
  by,
  ncol = NULL,
  nrow = NULL,
  byrow = NULL,
  widths = 30,
  heights = 25,
  guides = "collect",
  tag_level = NULL,
  design = NULL,
  unit = "mm"
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{by}{Variable that should be used for splitting.}

\item{ncol, nrow}{The number of columns and rows per page.}

\item{byrow}{Analogous to \code{byrow} in \link[base:matrix]{matrix()}. If \code{FALSE} the
plots will be filled in in column-major order}

\item{widths, heights}{The relative widths and heights of each column and row
in the grid. Will get repeated to match the dimensions of the grid. The
special value of \code{NA}/\verb{-1null} will behave as \verb{1null} unless a fixed aspect
plot is inserted in which case it will allow the dimension to expand or
contract to match the aspect ratio of the content}

\item{guides}{A string specifying how guides should be treated in the layout.
\code{'collect'} will collect guides below to the given nesting level, removing
duplicates. \code{'keep'} will stop collection at this level and let guides be
placed alongside their plot. \code{auto} will allow guides to be collected if a
upper level tries, but place them alongside the plot if not.  If you modify
default guide "position" with \link[ggplot2:theme]{theme(legend.position=...)}
while also collecting guides you must apply that change to the overall
patchwork (see example).}

\item{tag_level}{A string (\code{'keep'} or \code{'new'}) to indicate how
auto-tagging should behave. See \code{\link[patchwork:plot_annotation]{plot_annotation()}}.}

\item{design}{Specification of the location of areas in the layout. Can either
be specified as a text string or by concatenating calls to \code{\link[patchwork:area]{area()}} together.
See the examples for further information on use.}

\item{unit}{Unit of length. Defaults to \code{"mm"}.}
}
\value{
A \code{tidyplot} object.
}
\description{
Split plot into multiple subplots
}
\examples{
# Before splitting
energy |>
  dplyr::filter(year \%in\% c(2005, 2010, 2015, 2020)) |>
  tidyplot(y = energy, color = energy_source) |>
  add_donut()

# Split by year
energy |>
  dplyr::filter(year \%in\% c(2005, 2010, 2015, 2020)) |>
  tidyplot(y = energy, color = energy_source) |>
  add_donut() |>
  split_plot(by = year)

# Change dimensions of subplots
energy |>
  dplyr::filter(year \%in\% c(2005, 2010, 2015, 2020)) |>
  tidyplot(y = energy, color = energy_source) |>
  add_donut() |>
  split_plot(by = year, widths = 15, heights = 15)

# Spread plots across multiple pages
energy |>
  dplyr::filter(year \%in\% c(2005, 2010, 2015, 2020)) |>
  tidyplot(y = energy, color = energy_source) |>
  add_donut() |>
  split_plot(by = year, ncol = 2, nrow = 1)

}
