% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct_norm.R
\name{norm_dct_nearey}
\alias{norm_dct_nearey}
\title{Nearey DCT Normalization}
\usage{
norm_dct_nearey(
  .data,
  ...,
  .token_id_col,
  .by = NULL,
  .by_formant = FALSE,
  .param_col = NULL,
  .drop_orig = FALSE,
  .names = "{.formant}_lm",
  .silent = FALSE
)
}
\arguments{
\item{.data}{A data frame containing vowel formant data}

\item{...}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} One or more unquoted
expressions separated by commas. These should target the vowel formant
data columns.}

\item{.token_id_col}{\code{\link[rlang:args_data_masking]{<data-masking>}} A column
that identifies token ids.}

\item{.by}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} A selection of
columns to group by. Typically a column of speaker IDs.}

\item{.by_formant}{Whether or not the normalization method is formant
intrinsic.}

\item{.param_col}{A column identifying the DCT parameter number.}

\item{.drop_orig}{Should the originally targeted columns be dropped.}

\item{.names}{A \code{\link[glue:glue]{glue::glue()}} expression for naming the normalized
data columns. The \code{"{.formant}"} portion corresponds to the name of the original
formant columns.}

\item{.silent}{Whether or not the informational message should be printed.}
}
\value{
A data frame of Nearey normalized DCT coefficients
}
\description{
Nearey DCT Normalization
}
\details{
\strong{Important}: This function assumes that the DCT
coefficients were estimated over log-transformed
formant values.

When formant extrinsic:
\deqn{
 \hat{F}_{ij} = \log(F_{ij}) - L
}
\deqn{
 L = \frac{1}{MN}\sum_{i=1}^M\sum_{j=1}^N \log(F_{ij})
}

When formant intrinsic:
\deqn{
 \hat{F}_{ij} = \log(F_{ij}) - L_{i}
}

\deqn{
  L_i = \frac{1}{N}\sum_{j=1}^{N}\log(F_{ij})
}

Where
\itemize{
\item \eqn{\hat{F}} is the normalized formant
\item \eqn{i} is the formant number
\item \eqn{j} is the token number
}
}
\examples{
library(tidynorm)
library(dplyr)
ggplot2_inst <- require(ggplot2)

speaker_dct <- speaker_tracks |>
  mutate(
    across(
      F1:F3,
      log
    )
  ) |>
  reframe_with_dct(
    F1:F3,
    .by = speaker,
    .token_id_col = id,
    .time_col = t
  )

# Normalize DCT coefficients
speaker_dct_norm <- speaker_dct |>
  norm_dct_nearey(
    F1:F3,
    .by = speaker,
    .token_id_col = id,
    .param_col = .param
  )

# Apply average and apply inverse dct
# to plot tracks
track_norm_means <- speaker_dct_norm |>
  summarise(
    .by = c(speaker, vowel, .param),
    across(
      ends_with("_lm"),
      mean
    )
  ) |>
  reframe_with_idct(
    ends_with("_lm"),
    .by = speaker,
    .token_id_col = vowel,
    .param_col = .param
  )


if (ggplot2_inst) {
  track_norm_means |>
    ggplot(
      aes(F2_lm, F1_lm, color = speaker)
    ) +
    geom_path(
      aes(
        group = interaction(speaker, vowel)
      )
    ) +
    scale_x_reverse() +
    scale_y_reverse() +
    scale_color_brewer(palette = "Dark2") +
    coord_fixed()
}
}
\references{
Nearey, T. M. (1978). Phonetic Feature Systems for Vowels [Ph.D.].
University of Alberta.
}
