% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyllm_schema.R
\name{field_chr}
\alias{field_chr}
\alias{field_fct}
\alias{field_dbl}
\alias{field_lgl}
\title{Define Field Descriptors for JSON Schema}
\usage{
field_chr(.description = character(0), .vector = FALSE)

field_fct(.description = character(0), .levels, .vector = FALSE)

field_dbl(.description = character(0), .vector = FALSE)

field_lgl(.description = character(0), .vector = FALSE)
}
\arguments{
\item{.description}{A character string describing the field (optional).}

\item{.vector}{A logical value indicating if the field is a vector (default: FALSE).}

\item{.levels}{A character vector specifying allowable values (for \code{field_fct()} only).}
}
\value{
An S7 \code{tidyllm_field} object representing the field descriptor.
}
\description{
These functions create field descriptors used in \code{tidyllm_schema()} or \code{field_object()} to define JSON schema fields. They support character, factor, numeric, and logical types.
}
\examples{
field_chr("A common street name")
field_fct("State abbreviation", .levels = c("CA", "TX", "Other"))
field_dbl("House number")
field_lgl("Is residential")
field_dbl("A list of appartment numbers at the address",.vector=TRUE )
}
