% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin-estimates.R
\name{fit_effect}
\alias{fit_effect}
\title{Fits a treatment effect model using the appropriate settings}
\usage{
fit_effect(full_data, weight_col, fx_col, ..., .Model_cfg)
}
\arguments{
\item{full_data}{The full dataset of interest for the modelling problem.}

\item{weight_col}{The unquoted weighting variable name to use in model fitting.}

\item{fx_col}{The unquoted column name of the pseudo-outcome.}

\item{...}{The unquoted names of covariates to use in the model.}

\item{.Model_cfg}{A \code{Model_cfg} object configuring the appropriate model type to use.}
}
\value{
A list with one element, \code{fx}. This element contains a \code{Predictor} object of
the appropriate subclass corresponding to the \code{Model_cfg} fit to the data.
}
\description{
This function prepares data, fits the appropriate model and returns the
resulting estimates in a standardized format.
}
\keyword{internal}
