% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe-api.R
\name{add_effect_model}
\alias{add_effect_model}
\title{Add an additional model to the joint effect ensemble}
\usage{
add_effect_model(hte_cfg, model_name, ...)
}
\arguments{
\item{hte_cfg}{\code{HTE_cfg} object to update.}

\item{model_name}{Character indicating the name of the model to
incorporate into the joint effect ensemble. Possible values
use \code{SuperLearner} naming conventions. A full list is available
with \code{SuperLearner::listWrappers("SL")}}

\item{...}{Parameters over which to grid-search for this model class.}
}
\value{
Updated \code{HTE_cfg} object
}
\description{
This adds a learner to the ensemble used for estimating a model
of the conditional expectation of the pseudo-outcome.
}
\examples{
library("dplyr")
basic_config() \%>\%
   add_effect_model("SL.glm.interaction") -> hte_cfg
}
