% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_geocode.R
\name{reverse_geocode}
\alias{reverse_geocode}
\title{Reverse geocode coordinates in a dataframe}
\usage{
reverse_geocode(
  .tbl,
  lat,
  long,
  address = address,
  return_input = TRUE,
  limit = 1,
  return_coords = NULL,
  unique_only = FALSE,
  ...
)
}
\arguments{
\item{.tbl}{dataframe containing coordinates}

\item{lat}{latitude column name (input data). Can be quoted or unquoted (ie. lat or 'lat').}

\item{long}{longitude column name (input data). Can be quoted or unquoted (ie. long or 'long').}

\item{address}{address column name (output data). Can be quoted or unquoted (ie. addr or 'addr').}

\item{return_input}{if TRUE then the input dataset will be combined with the geocoder query results
and returned. If FALSE only the geocoder results will be returned.}

\item{limit}{maximum number of results to return per input coordinate. For many geocoder services
the maximum value of the limit parameter is 100. Pass \code{limit = NULL} to use
the default \code{limit} value of the selected geocoder service.
For batch geocoding, limit must be set to 1 (default) if \code{return_coords = TRUE}.
To use \code{limit > 1} or \code{limit = NULL} set return_input to FALSE.
Refer to \link{api_parameter_reference} for more details.}

\item{return_coords}{if TRUE return input coordinates. Defaults to TRUE if \code{return_input} is
FALSE and FALSE if \code{return_input} is TRUE. This argument is passed to the \code{reverse_geo()} function.}

\item{unique_only}{if TRUE then only unique results will be returned and
return_input will be set to FALSE.}

\item{...}{arguments passed to the \link{reverse_geo} function}
}
\value{
tibble (dataframe)
}
\description{
Takes a dataframe containing coordinates (latitude and longitude) and returns
the reverse geocoding query results from a specified service by using the
\link{reverse_geo} function. See example usage in \code{vignette("tidygeocoder")}.

This function passes all additional parameters (\code{...}) to the
\link{reverse_geo} function, so you can refer to its documentation for more details
on possible arguments.
}
\examples{
\donttest{
library(tibble)
library(dplyr)

tibble(
    latitude = c(38.895865, 43.6534817),
    longitude = c(-77.0307713,-79.3839347)
  ) \%>\%
  reverse_geocode(
    lat = latitude,
    long = longitude,
    method = 'osm',
    full_results = TRUE
  )

louisville \%>\% head(3) \%>\% 
  reverse_geocode(lat = latitude, long = longitude, 
  method = 'arcgis')

louisville \%>\% head(2) \%>\% 
  reverse_geocode(lat = latitude, long = longitude,  
  method = 'osm', verbose = TRUE,
  limit = 2, return_input = FALSE)

}
}
\seealso{
\link{reverse_geo}
}
