% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{gate}
\alias{gate}
\title{Gate points}
\usage{
gate(
  x,
  y,
  colour = NULL,
  shape = NULL,
  alpha = 1,
  size = 2,
  programmatic_gates = NULL
)
}
\arguments{
\item{x}{A vector representing the X dimension.}

\item{y}{A vector representing the Y dimension.}

\item{colour}{A single colour code string compatible with ggplot2. Or, a vector representing the 
point colour.}

\item{shape}{A single ggplot2 shape numeric ranging from 0 to 127. Or, a vector representing the 
point shape, coercible to a factor of 6 or less levels.}

\item{alpha}{A single ggplot2 alpha numeric ranging from 0 to 1. Or, a vector representing the 
point alpha, either a numeric or factor of 6 or less levels.}

\item{size}{A single ggplot2 size numeric ranging from 0 to 20. Or, a vector representing the 
point size, either a numeric or factor of 6 or less levels.}

\item{programmatic_gates}{A `data.frame` of the gate brush data, as saved in 
`tidygate_env$gates`. The column `x` records X coordinates, the column `y` records Y coordinates and the column `.gate` 
records the gate number. When this argument is supplied, gates will be drawn programmatically.}
}
\value{
A vector of strings, of the gates each X and Y coordinate pair is within. If gates are
drawn interactively, they are temporarily saved to `tidygate_env$gates`.
}
\description{
Gate points based on their X and Y coordinates. By default, this function launches an interactive
scatter plot. Colour, shape, size and alpha can be defined as constant values, or can be 
controlled by the values of a specified column. 

If previously drawn gates are supplied to the `programmatic_gates` argument, points will be gated 
programmatically. This feature allows the reproduction of previously drawn interactive gates.
Programmatic gating is based on the package gatepoints by Wajid Jawaid.
}
\examples{
library(dplyr)
data("demo_gate_data", package = "tidygate")

# Gate points interactively
if(interactive()) {
  mtcars |>
    mutate(gated = gate(x = mpg, y = wt, shape = am))
}

# Gate points programmatically
mtcars |>
  mutate(gated = gate(x = mpg, y = wt, programmatic_gates = demo_gate_data))
}
