% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wider_dt.R
\name{wider_dt}
\alias{wider_dt}
\title{Pivot data from long to wide}
\usage{
wider_dt(
  data,
  group_to_keep = NULL,
  name_to_spread,
  value_to_spread = NULL,
  fill = NA
)
}
\arguments{
\item{data}{data.table}

\item{group_to_keep}{The unchanged group in the transformation.
Could use integer vector, character vector or regular expression(to match
the column names). If \code{NULL}, use all other variables.}

\item{name_to_spread}{Chracter.One column name of class to spread}

\item{value_to_spread}{Chracter.One column name of value to spread.
If \code{NULL}, use all other variables.}

\item{fill}{Value with which to fill missing cells. Default uses \code{NA}.}
}
\value{
data.table
}
\description{
Analogous function for \code{pivot_wider} in \pkg{tidyr}.
}
\examples{
 stocks = data.frame(
   time = as.Date('2009-01-01') + 0:9,
   X = rnorm(10, 0, 1),
   Y = rnorm(10, 0, 2),
   Z = rnorm(10, 0, 4)
 ) \%>\%
   longer_dt(time) -> longer_stocks

 longer_stocks

 longer_stocks \%>\%
   wider_dt("time","variable","value")

 longer_stocks \%>\%
   mutate_dt(one = 1) \%>\%
   wider_dt("time","variable","one")

}
\seealso{
\code{\link[data.table]{dcast}}

\code{\link[tidyr]{pivot_wider}}
}
