% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing.R
\name{drop_na_dt}
\alias{drop_na_dt}
\alias{replace_na_dt}
\title{Dump or replace missing values in data.frame}
\usage{
drop_na_dt(data, ...)

replace_na_dt(data, ..., to)
}
\arguments{
\item{data}{data.frame}

\item{...}{Colunms to be replaced. If not specified, use all columns.}

\item{to}{What value should NA replace by?}
}
\value{
data.table
}
\description{
Analogous function for \code{drop_na} and \code{replace_na} in \pkg{tidyr}, but with a different API.
}
\examples{
df <- data.table(x = c(1, 2, NA), y = c("a", NA, "b"))
df \%>\% drop_na_dt()
df \%>\% drop_na_dt(x)

df \%>\% replace_na_dt(to = 0)
df \%>\% replace_na_dt(x,to = 0)
df \%>\% replace_na_dt(y,to = 0)
}
\references{
https://stackoverflow.com/questions/7235657/fastest-way-to-replace-nas-in-a-large-data-table
}
\seealso{
\code{\link[tidyr]{drop_na}},\code{\link[tidyr]{replace_na}}
}
