% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.subset.R
\name{.fit.subset}
\alias{.fit.subset}
\title{Best subset regression and classification for \code{tidyfit}}
\usage{
\method{.fit}{subset}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a best subset regression or classification on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}} and \code{\link{classify}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}
\itemize{
\item \code{method} (e.g. 'forward', 'backward')
\item \code{IC} (information criterion, e.g. 'AIC')
}

The best subset regression is estimated using \code{bestglm::bestglm} which is a wrapper around \code{leaps::regsubsets} for the regression case, and performs an exhaustive search for the classification case. See \code{?bestglm} for more details.

\strong{Implementation}

Forward or backward selection can be performed by passing \code{method = "forward"} or \code{method = "backward"} to \code{\link{m}}.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns

# Stand-alone function
fit <- m("subset", Return ~ ., data, method = c("forward", "backward"))
tidyr::unnest(fit, settings)

# Within 'regress' function
fit <- regress(data, Return ~ ., m("subset", method = "forward"),
               .mask = c("Date", "Industry"))
coef(fit)

}
\references{
A.I. McLeod, Changjiang Xu and Yuanhao Lai (2020).
\emph{bestglm: Best Subset GLM and Regression Utilities.
R package version 0.37.3.} URL https://CRAN.R-project.org/package=bestglm.\cr
}
\seealso{
\code{\link{.fit.lm}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
