% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.relief.R
\name{.model.relief}
\alias{.model.relief}
\title{ReliefF and RReliefF feature selection algorithm for \code{tidyfit}}
\usage{
\method{.model}{relief}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Selects features for continuous or factor data using ReliefF on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}} and \code{\link{classify}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}
\itemize{
\item estimator (\emph{selection algorithm to use (default is 'ReliefFequalK')})
}

The ReliefF algorithm is estimated using the \code{CORElearn::attrEval} function. See \code{?attrEval} for more details.

\strong{Implementation}

Use with \code{\link{regress}} for regression problems and with \code{\link{classify}} for classification problems. \code{coef} returns the score for each feature. Select the required number of features with the largest scores.

The Relief objects have no \code{predict} and related methods.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns
data <- dplyr::filter(data, Industry == "HiTec")
data <- dplyr::select(data, -Date, -Industry)

# Stand-alone function
fit <- m("relief", Return ~ ., data)
coef(fit)

# Within 'regress' function
fit <- regress(data, Return ~ ., m("relief"))
coef(fit)

}
\references{
Robnik-Sikonja M, Savicky P (2021).
\emph{CORElearn: Classification, Regression and Feature Evaluation}.
R package version 1.56.0, \url{https://CRAN.R-project.org/package=CORElearn}.
}
\seealso{
\code{\link{.model.mrmr}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
