% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_wrds_clean_trace.R
\name{download_data_wrds_clean_trace}
\alias{download_data_wrds_clean_trace}
\title{Download Cleaned TRACE Data from WRDS}
\usage{
download_data_wrds_clean_trace(cusips, start_date, end_date)
}
\arguments{
\item{cusips}{A character vector specifying the 9-digit CUSIPs to download.}

\item{start_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the start date for the data. If not provided, a subset of the dataset is returned.}

\item{end_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the end date for the data. If not provided, a subset of the dataset is returned.}
}
\value{
A data frame containing the cleaned trade messages from TRACE for the
selected CUSIPs over the time window specified. Output variables include
identifying information (i.e., CUSIP, trade date/time) and trade-specific
information (i.e., price/yield, volume, counterparty, and reporting side).
}
\description{
Establishes a connection to the WRDS database to download the specified
CUSIPs trade messages from the Trade Reporting and Compliance Engine (TRACE).
The trade data is cleaned as suggested by Dick-Nielsen (2009, 2014).
}
\examples{
\donttest{
  clean_trace <- download_data_wrds_clean_trace("00101JAH9", "2019-01-01", "2021-12-31")
}
}
