% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{dt_print_options}
\alias{dt_print_options}
\title{Set Print Method}
\usage{
dt_print_options(
  class = TRUE,
  topn = 5,
  rownames = TRUE,
  nrows = 100,
  trunc.cols = TRUE
)
}
\arguments{
\item{class}{should the variable class be printed? (\code{options("datatable.print.class")})}

\item{topn}{the number of rows to print (both head and tail) if \code{nrows(DT) > nrows}. (\code{options("datatable.print.topn")})}

\item{rownames}{should rownames be printed? (\code{options("datatable.print.rownames")})}

\item{nrows}{total number of rows to print (\code{options("datatable.print.nrows")})}

\item{trunc.cols}{if \code{TRUE}, only the columns that fit in the console are printed (with a message stating the variables not shown, similar to \code{tibbles}; \code{options("datatable.print.trunc.cols")}). This only works on \code{data.table} versions higher than \code{1.12.6} (i.e. not currently available but anticipating the eventual release).}
}
\value{
None. This function is used for its side effect of changing options.
}
\description{
The function allows the user to define options relating to the print method for \code{data.table}.
}
\examples{

dt_print_options(
  class = TRUE,
  topn = 5,
  rownames = TRUE,
  nrows = 100,
  trunc.cols = TRUE)

}
