% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_chart_functions.R
\name{column_chart_normalized}
\alias{column_chart_normalized}
\title{Generate column chart with normalization. Every column will be rescaled, so columns have the same height.}
\usage{
column_chart_normalized(
  data,
  x,
  series = NULL,
  series_labels = series,
  interval = "months"
)
}
\arguments{
\item{data}{data frame in wide format containing data to be plotted}

\item{x}{vector containing labels for x axis or name of column in data with values of x axis labels}

\item{series}{vector containing names of columns in data with values to plot}

\item{series_labels}{optional vector with labels for series to be plotted as legend. The default is the same as series.}

\item{interval}{intervals on x axis. The width of the bars depends on this parameter}
}
\value{
SVG string containing chart
}
\description{
Generate column chart with normalization. Every column will be rescaled, so columns have the same height.
}
\examples{
# prepare some data frame
df <- data.frame(x = month.abb[1:6],
                 y = c(2, 4, 2, 1, 2.5, 3),
                 z = c(3, 4.5, 2, 1, 4, 2))

# generate character vector with svg data
svg <- column_chart_normalized(df, x = df$x, series = c('y', 'z'))

# show the plot
svg \%>\% SVGrenderer()
}
