% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimates.R
\name{get_estimates}
\alias{get_estimates}
\title{Get data from the US Census Bureau Population Estimates Program}
\usage{
get_estimates(
  geography = c("us", "region", "division", "state", "county", "county subdivision",
    "place/balance (or part)", "place", "consolidated city", "place (or part)",
    "metropolitan statistical area/micropolitan statistical area", "cbsa",
    "metropolitan division", "combined statistical area"),
  product = NULL,
  variables = NULL,
  breakdown = NULL,
  breakdown_labels = FALSE,
  year = 2019,
  state = NULL,
  county = NULL,
  time_series = FALSE,
  output = "tidy",
  geometry = FALSE,
  keep_geo_vars = FALSE,
  shift_geo = FALSE,
  key = NULL,
  show_call = FALSE,
  ...
)
}
\arguments{
\item{geography}{The geography of your data. Available geographies for the most recent data vintage are listed
\href{https://api.census.gov/data/2019/pep/population/geography.html}{here}. \code{"cbsa"} may
be used an alias for \code{"metropolitan statistical area/micropolitan statistical area"}.}

\item{product}{The data product (optional). \code{"population"}, \code{"components"}
               \code{"housing"}, and \code{"characteristics"} are supported.

               Not yet supported for 2020 and later.}

\item{variables}{A character string or vector of character strings of requested variables.  For years 2020 and later, use \code{variables = "all"} to request all available variables.}

\item{breakdown}{The population breakdown used when \code{product = "characteristics"}.
                 Acceptable values are \code{"AGEGROUP"}, \code{"RACE"}, \code{"SEX"}, and
                 \code{"HISP"}, for Hispanic/Not Hispanic.  These values can be combined in
                 a vector, returning population estimates in the \code{value} column for all
                 combinations of these breakdowns.

                 Not yet supported for 2020 and later.}

\item{breakdown_labels}{Whether or not to label breakdown elements returned when
                        \code{product = "characteristics"}. Defaults to FALSE.

                        Not yet supported for 2020 and later.}

\item{year}{The data vintage (defaults to 2019). It is recommended to use the most recent vintage
available for a given decennial series (so, year = 2019 for the 2010s, and year = 2022 for the 2020s)
and use \code{time_series = TRUE} to access estimates for prior years.}

\item{state}{The state for which you are requesting data. State
names, postal codes, and FIPS codes are accepted.
Defaults to NULL.}

\item{county}{The county for which you are requesting data. County names and
FIPS codes are accepted. Must be combined with a value supplied
to `state`.  Defaults to NULL.}

\item{time_series}{If \code{TRUE}, the function will return a time series of observations back to the decennial Census
of 2010. The returned column is either "DATE", representing a particular estimate date, or "PERIOD",
representing a time period (e.g. births between 2016 and 2017), and contains integers representing
those values.  Integer to date or period mapping is available at
\url{https://www.census.gov/data/developers/data-sets/popest-popproj/popest/popest-vars/2019.html}.}

\item{output}{One of "tidy" (the default) in which each row represents an
enumeration unit-variable combination, or "wide" in which each
row represents an enumeration unit and the variables are in the
columns.}

\item{geometry}{if FALSE (the default), return a regular tibble of ACS data.
if TRUE, uses the tigris package to return an sf tibble
with simple feature geometry in the `geometry` column.}

\item{keep_geo_vars}{if TRUE, keeps all the variables from the Census
shapefile obtained by tigris.  Defaults to FALSE.}

\item{shift_geo}{(deprecated) if TRUE, returns geometry with Alaska and Hawaii shifted for thematic
mapping of the entire US.  As of May 2021, we recommend using \code{tigris::shift_geometry()}
instead.}

\item{key}{Your Census API key.
Obtain one at \url{https://api.census.gov/data/key_signup.html}.  Can be stored
in your .Renviron with \code{census_api_key("YOUR KEY", install = TRUE)}}

\item{show_call}{if TRUE, display call made to Census API. This can be very useful
in debugging and determining if error messages returned are
due to tidycensus or the Census API. Copy to the API call into
a browser and see what is returned by the API directly. Defaults to FALSE.}

\item{...}{other keyword arguments}
}
\value{
A tibble, or sf tibble, of population estimates data
}
\description{
\code{get_estimates()} requests data from the Population Estimates API for years 2019 and earlier; however the Popuplation Estimates are no longer supported on the API as of 2020.  For recent years, \code{get_estimates()} reads a flat file from the Census website and parses it.  This means that arguments and output for 2020 and later datasets may differ slightly from datasets acquired for 2019 and earlier.
}
\details{
As of April 2022, variables available for 2020 and later datasets are as follows: ESTIMATESBASE, POPESTIMATE, NPOPCHG, BIRTHS, DEATHS, NATURALCHG, INTERNATIONALMIG, DOMESTICMIG, NETMIG, RESIDUAL, GQESTIMATESBASE, GQESTIMATES, RBIRTH, RDEATH, RNATURALCHG, RINTERNATIONALMIG, RDOMESTICMIG, and RNETMIG.
}
