% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_bins.R
\name{bin_cols}
\alias{bin_cols}
\title{Bin Cols}
\usage{
bin_cols(
  .data,
  col,
  n_bins = 10,
  bin_type = "frequency",
  ...,
  target = NULL,
  pretty_labels = FALSE,
  seed = 1,
  method = "mdlp"
)
}
\arguments{
\item{.data}{a data frame}

\item{col}{a column, vector of columns, or tidyselect}

\item{n_bins}{number of bins}

\item{bin_type}{method to make bins}

\item{...}{params to be passed to selected binning method}

\item{target}{unquoted column for supervised binning}

\item{pretty_labels}{logical. If T returns interval label rather than integer rank}

\item{seed}{seed for stochastic binning (xgboost)}

\item{method}{method for bin mdlp}
}
\value{
a data frame
}
\description{
Make bins in a tidy fashion. Adds a column to your data frame containing the integer codes of the specified bins of a certain column.
Specifying multiple columns is only intended for supervised binning, so mutliple columns can be simultaneously binned
optimally with respect to a target variable.
}
\details{
Description of the arguments for bin_type

\describe{
  \item{\emph{frequency (fr)}}{ creates bins of equal content via quantiles. Wraps \code{\link[OneR]{bin}} with method "content". Similar to  \code{\link[dplyr]{ntile}}}
  \item{\emph{width (wi)}}{ create bins of equal numeric width. Wraps \code{\link[OneR]{bin}} with method "length"}
  \item{\emph{kmeans (km)}}{ create bins using 1-dimensional kmeans. Wraps \code{\link[OneR]{bin}} with method "clusters"}
  \item{\emph{value (va)}}{ each bin has equal sum of values}
  \item{\emph{xgboost (xg)}}{ column is binned by best predictor of a target column using  \code{\link[embed]{step_discretize_xgb}} }
  \item{\emph{cart (ca)}}{ if the col does not have enough distinct values, xgboost will fail and automatically revert to \code{\link[embed]{step_discretize_cart}} }
  \item{\emph{woe (wo)}}{ column is binned by weight of evidence. Requires binary target}
  \item{\emph{logreg (lr)}}{ column is binned by logistic regression. Requires binary target.}
  \item{\emph{mdlp}}{ uses the \code{\link[arulesCBA]{discretizeDF.supervised}} algorithm with a variety of methods.}
}
}
\examples{

iris \%>\%
bin_cols(Sepal.Width, n_bins = 5, pretty_labels = TRUE) \%>\%
bin_cols(Petal.Width, n_bins = 3, bin_type = c("width", "kmeans")) \%>\%
bin_cols(Sepal.Width, bin_type = "xgboost", target = Species, seed = 1) -> iris1

#binned columns are named by original name + method abbreviation + number bins created.
#Sometimes the actual number of bins is less than n_bins if the col lacks enough variance.
iris1 \%>\%
print(width = Inf)

iris1 \%>\%
bin_summary() \%>\%
print(width = Inf)
}
