% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_dist.R
\name{parse_dist}
\alias{parse_dist}
\alias{parse_dist.default}
\alias{parse_dist.data.frame}
\alias{parse_dist.character}
\alias{parse_dist.factor}
\alias{r_dist_name}
\title{Parse distribution specifications into columns of a data frame}
\usage{
parse_dist(object, ..., dist = ".dist", args = ".args", to_r_names = TRUE)

\method{parse_dist}{default}(object, ...)

\method{parse_dist}{data.frame}(
  object,
  dist_col,
  ...,
  dist = ".dist",
  args = ".args",
  to_r_names = TRUE
)

\method{parse_dist}{character}(object, ..., dist = ".dist", args = ".args", to_r_names = TRUE)

\method{parse_dist}{factor}(object, ..., dist = ".dist", args = ".args", to_r_names = TRUE)

r_dist_name(dist_name)
}
\arguments{
\item{object}{A character vector containing distribution specifications or a data frame with a column
containing distribution specifications.}

\item{...}{Arguments passed to other implementations of \code{parse_dist}.}

\item{dist}{The name of the output column to contain the distribution name}

\item{args}{The name of the output column to contain the arguments to the distribution}

\item{to_r_names}{If \code{TRUE} (the default), certain common aliases for distribution names are
automatically translated into names that R can recognize (i.e., names which have functions starting
with \code{r}, \code{p}, \code{q}, and \code{d} representing random number generators, distribution
functions, etc. for that distribution), using the \code{r_dist_name} function. For example,
\code{"normal"} is translated into \code{"norm"} and \code{"lognormal"} is translated into \code{"lnorm"}.}

\item{dist_col}{A bare (unquoted) column or column expression that resolves to a character vector
of distribution specifications.}

\item{dist_name}{For \code{r_dist_name}, a character vector of distribution names to be translated into
distribution names R recognizes. Unrecognized names are left as-is.}
}
\description{
Parses simple string distribution specifications, like \code{"normal(0, 1)"}, into two columns of
a data frame, suitable for use with \code{\link[=stat_dist_slabinterval]{stat_dist_slabinterval()}} and its shortcut stats
(like \code{stat_dist_halfeye}). This format is output
by \code{\link[brms:get_prior]{brms::get_prior()}}, making it particularly useful for visualizing priors from
brms models.
}
\details{
\code{parse_dist()} can be applied to character vectors or to a data frame + bare column name of the
column to parse, and returns a data frame with \code{".dist"} and \code{".args"} columns added.
\code{parse_dist()} uses \code{r_dist_name()} to translate distribution names into names recognized
by R.

\code{r_dist_name()} takes a character vector of names and translates common names into R
distribution names. Names are first made into valid R names using \code{\link[=make.names]{make.names()}},
then translated (ignoring character case, \code{"."}, and \code{"_"}). Thus, \code{"lognormal"},
\code{"LogNormal"}, \code{"log_normal"}, \code{"log-Normal"}, and any number of other variants
all get translated into \code{"lnorm"}.
}
\examples{

library(dplyr)

# parse dist can operate on strings directly...
parse_dist(c("normal(0,1)", "student_t(3,0,1)"))

# ... or on columns of a data frame, where it adds the
# parsed specs back on as columns
data.frame(prior = c("normal(0,1)", "student_t(3,0,1)")) \%>\%
  parse_dist(prior)

if (
  require("brms", quietly = TRUE)
) {

  # parse_dist is particularly useful with brms prior specifications,
  # which follow the same format...

  # get priors for a brms model
  priors = get_prior(mpg ~ log(hp), data = mtcars, family = lognormal)

  # The `prior` column output by `get_prior()` is a character vector
  # of distribution specifications. We can parse this directly...
  parse_dist(priors$prior)

  # ... or we can parse it and have it added back onto the original data frame
  # (this form is likely more useful for plotting, since the other columns
  # are retained)
  parse_dist(priors, prior)

}

}
\seealso{
See \code{\link[=stat_dist_slabinterval]{stat_dist_slabinterval()}} and its shortcut stats, which can easily make use of
the output of this function using the \code{dist} and \code{args} aesthetics.
}
