% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_rocky_mtn.R
\name{micro_rocky_mtn}
\alias{micro_rocky_mtn}
\title{Create Rocky Mountain plots from negative binomial taxa models}
\usage{
micro_rocky_mtn(
  modsum,
  ...,
  main = NULL,
  ylab = NULL,
  subtitle = NULL,
  pval_lines = TRUE,
  pval_text = TRUE,
  sig_text = TRUE,
  facet_labels = NULL,
  alpha = 0.05,
  lwd = 2,
  lty = 1
)
}
\arguments{
\item{modsum}{The output from nb_mods}

\item{...}{The covariate you'd like to plot. Must be in the models created by nb_mods}

\item{main}{Plot title}

\item{ylab}{y-axis labels}

\item{subtitle}{Plot subtitle}

\item{pval_lines}{Logical; include horizonal dashed lines at corresponding p-values}

\item{pval_text}{Logical; label the y-axis with corresponding p-values}

\item{sig_text}{Logical; label the taxa with p-values below specified alpha}

\item{facet_labels}{Labels for different facets if covariate has more than 1 beta coefficient}

\item{alpha}{Significance cutoff}

\item{lwd}{Line width for pval_lines}

\item{lty}{Line type for pval_lines}
}
\value{
A ggplot you can add geoms to if you'd like
}
\description{
Display the magnitude of log p-values for each of the taxa in \code{nb_mods} as vertical bars next to each other along the x-axis. The direction of the bars will be determined by the direction of the estimated relationship. The taxa will be color coded by the phylum they belong to, and taxa that have FRD adjusted p-values below your desired significance cutoff for the specified covariate will be labeled
}
\examples{
data(bpd_phy); data(bpd_cla); data(bpd_ord); data(bpd_fam); data(bpd_clin)
otu_tabs = list(Phylum = bpd_phy, Class = bpd_cla,
Order = bpd_ord, Family = bpd_fam)

set <- tidy_micro(otu_tabs = otu_tabs, clinical = bpd_clin) \%>\%
filter(day == 7) ## Only including the first week

## Creating negative binomial models on filtered tidy_micro set
nb_fam <- set \%>\%
otu_filter(ra_cutoff = 0.1, exclude_taxa = c("Unclassified", "Bacteria")) \%>\%
nb_mods(table = "Family", bpd1)

nb_fam \%>\% micro_rocky_mtn(bpd1)
}
\author{
Charlie Carpenter, Rachel Johnson, Dan Frank
}
