% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_rank_sum.R
\name{micro_rank_sum}
\alias{micro_rank_sum}
\title{Run rank sum tests for each taxa within an OTU table}
\usage{
micro_rank_sum(micro_set, table, grp_var, y = ra, mod = NULL, ...)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{OTU table of interest}

\item{grp_var}{A factor variable for grouping}

\item{y}{A continuous response variable. Taxa relative abundance (ra) is recommended}

\item{mod}{The output from \code{\link[tidyMicro]{nb_mods}} or \code{\link[tidyMicro]{bb_mods}} if desired}

\item{...}{Options to be passed to \code{\link[stats]{wilcox.test}} or \code{\link[stats]{kruskal.test}}}
}
\value{
A data frame containing the p-value for each taxa's rank sum test.
}
\description{
Runs a rank sum test for each taxa within an OTU table or each taxa that didn't converge in \code{\link[tidyMicro]{nb_mods}} or \code{\link[tidyMicro]{bb_mods}}
}
\details{
The grp_var must have a least 2 levels. For a 2 level factor a Mann-Whitney test will be calculated through \code{\link[stats]{wilcox.test}}, and for 3 or more levels a Kruskal-Wallis test will be run throuh \code{\link[stats]{kruskal.test}}
}
\examples{
data(bpd_cla); data(bpd_clin)

set <- tidy_micro(otu_tabs = bpd_cla, tab_names = "Class", clinical = bpd_clin,
prev_cutoff = 5, ra_cutoff = 0.1, exclude_taxa = c("Unclassified", "Bacteria")) \%>\%
filter(day == 7) ## Only including the first week

## Rank sum test on every taxa's relative abundance
set \%>\% micro_rank_sum(table = "Class", grp_var = bpd1)

## Rank sum test on every taxa whose model didn't converge
nb_cla <- nb_mods(set, table = "Class", bpd1)

micro_rank_sum(micro_set = set, table = "Class",
grp_var = bpd1, mod = nb_cla)
}
\references{
\code{\link[stats]{kruskal.test}} and \code{\link[stats]{wilcox.test}}
}
