% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_meta.R
\name{bf_meta}
\alias{bf_meta}
\title{Bayes factor for random-effects meta-analysis}
\usage{
bf_meta(
  data,
  d = prior("norm", c(mean = 0, sd = 0.3)),
  tau = prior("invgamma", c(shape = 1, scale = 0.15)),
  k = 2L,
  output = "results",
  caption = NULL,
  messages = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe. It \strong{must} contain columns named \code{estimate} (effect
sizes or outcomes)  and \code{std.error} (corresponding standard errors). These
two columns will be used for \code{yi}  and \code{sei} arguments in \code{metafor::rma}
(for parametric analysis) or \code{metaplus::metaplus} (for robust analysis).}

\item{d}{\code{prior} distribution on the average effect size \code{d}. The
prior probability density function is defined via \code{\link[metaBMA]{prior}}.}

\item{tau}{\code{prior} distribution on the between-study heterogeneity
\code{tau} (i.e., the standard deviation of the study effect sizes
\code{dstudy} in a random-effects meta-analysis. A (nonnegative) prior
probability density function is defined via \code{\link[metaBMA]{prior}}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{output}{Can either be \code{"null"} (or \code{"caption"} or \code{"H0"} or \code{"h0"}),
which will return expression with evidence in favor of the null hypothesis,
or \code{"alternative"} (or \code{"title"} or \code{"H1"} or \code{"h1"}), which will return
expression with evidence in favor of the alternative hypothesis, or
\code{"results"}, which will return a dataframe with results all the details).}

\item{caption}{Text to display as caption (will be displayed on top of the
Bayes Factor caption/message).}

\item{messages}{Deprecated. Retained only for backward compatibility.}

\item{...}{
  Arguments passed on to \code{\link[metaBMA:meta_random]{metaBMA::meta_random}}
  \describe{
    \item{\code{labels}}{optional: character values with study labels. Can be a
character vector or the quoted or unquoted name of the variable in
\code{data}}
    \item{\code{rscale_contin}}{scale parameter of the JZS prior for the continuous
covariates.}
    \item{\code{rscale_discrete}}{scale parameter of the JZS prior for discrete
moderators.}
    \item{\code{centering}}{whether continuous moderators are centered.}
    \item{\code{logml}}{how to estimate the log-marginal likelihood: either by numerical
integration (\code{"integrate"}) or by bridge sampling using MCMC/Stan
samples (\code{"stan"}). To obtain high precision with \code{logml="stan"},
many MCMC samples are required (e.g., \code{logml_iter=10000, warmup=1000}).}
    \item{\code{summarize}}{how to estimate parameter summaries (mean, median, SD,
etc.): Either by numerical integration (\code{summarize = "integrate"}) or
based on MCMC/Stan samples (\code{summarize = "stan"}).}
    \item{\code{ci}}{probability for the credibility/highest-density intervals.}
    \item{\code{rel.tol}}{relative tolerance used for numerical integration using
\code{\link[stats]{integrate}}. Use \code{rel.tol=.Machine$double.eps} for
maximal precision (however, this might be slow).}
    \item{\code{logml_iter}}{number of iterations (per chain) from the posterior
distribution of \code{d} and \code{tau}. The samples are used for computing
the marginal likelihood of the random-effects model with bridge sampling
(if \code{logml="stan"}) and for obtaining parameter estimates (if
\code{summarize="stan"}). Note that the argument \code{iter=2000} controls
the number of iterations for estimation of the random-effect parameters per
study in random-effects meta-analysis.}
    \item{\code{silent_stan}}{whether to suppress the Stan progress bar.}
  }}
}
\description{
Bayes factor for random-effects meta-analysis
}
\examples{

\donttest{
# setup
set.seed(123)
library(metaBMA)

# creating a dataframe
(df <-
  structure(
    .Data = list(
      study = c("1", "2", "3", "4", "5"),
      estimate = c(
        0.382047603321706,
        0.780783111514665,
        0.425607573765058,
        0.558365541235078,
        0.956473848429961
      ),
      std.error = c(
        0.0465576338644502,
        0.0330218199731529,
        0.0362834986178494,
        0.0480571500648261,
        0.062215818388157
      )
    ),
    row.names = c(NA, -5L),
    class = c("tbl_df", "tbl", "data.frame")
  ))

# getting Bayes factor in favor of null hypothesis
bf_meta(
  data = df,
  k = 3,
  iter = 1500,
  messages = TRUE,
  # customizing analysis with additional arguments
  control = list(max_treedepth = 15)
)
}

}
