% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xhash.R
\name{xhash}
\alias{xhash}
\title{Create Hash Table for Generic Keys}
\usage{
xhash(convfunc = function(state, ...) state, convfunc_vec = function(states,
  ...) unlist(Map(convfunc, states, ...)), default_value = NULL)
}
\arguments{
\item{convfunc}{function that converts a game state to a key.
It must take a positional argument \code{state} and keyword arguments
represented by \code{...}, and returns a character.}

\item{convfunc_vec}{function for vectorized conversion from states to keys.
This function must receive a positional argument \code{states}
and keyword arguments \code{...}
and returns character vector.  By default, it tries to vectorize
\code{convfunc} using \code{Map}. User may specify more efficient function
if any.}

\item{default_value}{value to be returned when a state is not recorded in
the table.}
}
\value{
\code{game_ht} object
}
\description{
Create Hash Table for Generic Keys
}

