% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan.R
\name{make_lavaan_code}
\alias{make_lavaan_code}
\title{Generate lavaan code for Thurstonian IRT models}
\usage{
make_lavaan_code(data)
}
\arguments{
\item{data}{An object of class \code{'TIRTdata'}. see
\code{\link{make_TIRT_data}} for documentation on how to create one.}
}
\value{
A character string of lavaan code
for a Thurstonian IRT model.
}
\description{
Generate lavaan code for Thurstonian IRT models
}
\examples{
lambdas <- c(runif(6, 0.5, 1), runif(6, -1, -0.5))
sim_data <- sim_TIRT_data(
  npersons = 100,
  ntraits = 3,
  nblocks_per_trait = 4,
  gamma = 0,
  lambda = lambdas,
  Phi = diag(3)
)
cat(make_lavaan_code(sim_data))

}
