% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_matrix.R
\name{as_matrix}
\alias{as_matrix}
\title{Convert matrix into dense/sparse matrix}
\usage{
as_matrix(x, return_sparse = FALSE)
}
\arguments{
\item{x}{A matrix.}

\item{return_sparse}{Whether to output a sparse matrix.
Default is \code{FALSE}.}
}
\value{
A dense or sparse matrix.
}
\description{
Convert matrix into dense/sparse matrix
}
\examples{
m <- simulate_sparse_matrix(
  1000, 1000,
  decimal = 3
)

a <- as_matrix(m)
a[1:5, 1:5]

b <- as_matrix(m, return_sparse = TRUE)
b[1:5, 1:5]
}
