% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{invoke_fun}
\alias{invoke_fun}
\title{Invoke a function with a list of arguments}
\usage{
invoke_fun(.fn, .args = list(), ..., .env = rlang::caller_env())
}
\arguments{
\item{.fn}{A function, or function name as a string.}

\item{.args}{A list of arguments.}

\item{...}{Other arguments passed to the function.}

\item{.env}{Environment in which to evaluate the call.
This will be most useful if \code{.fn} is a string,
or the function has side-effects.}
}
\description{
Invoke a function with a list of arguments
}
\examples{
f <- function(x, y) {
  x + y
}
invoke_fun(f, list(x = 1, y = 2))
invoke_fun("f", list(x = 1, y = 2))
invoke_fun("f", x = 1, y = 2)
}
