% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TheiaCollection.R
\name{TheiaCollection}
\alias{TheiaCollection}
\title{A collection of tiles from Theia}
\description{
Generate and manage collection of tiles from Theia. This collection can be
created either from a cart file ('.meta4') downloaded from Theia website,
from a \code{\link{TheiaQuery}} object or from a list of
\code{\link{TheiaTile}} (not implemented yet).
}
\section{Usage}{

\preformatted{
   c <- TheiaCollection$new(cart.path = NULL,
                            tiles     = NULL,
                            query     = NULL,
                            dir.path  = NULL,
                            check     = TRUE)
                            quiet     = TRUE)

   c$download(auth, overwrite = FALSE, check = TRUE, quiet = TRUE)
   c$check()
   c$status
   c$extract(overwrite = FALSE, dest.dir = NULL)
   c$read(bands)
   c$as_gdalcube(out.file = "gdalcube_collection.sqlite")
}
}

\section{Arguments}{


\describe{
   \item{c:}{A \code{TheiaCollection} object}
   \item{dir.path:}{The path to the directory containing zip files}
   \item{check:}{Whether or not to check existing files on collection's creation}
   \item{quiet:}{Control verbose output}
   \item{tiles:}{A list of TheiaTile objects}
   \item{cart:}{An XML cart parsed from a 'meta4' file downloaded from Theia}
   website. Used only if Collection is created from a cart
   \item{query:}{A TheiaQuery object, used only if collection is created
   from a TheiaQuery object. Can also be a list with search terms. In this
   case, it will create a `TheiaQuery` object from it. See
   \code{\link{TheiaQuery}} for details on query syntax}
   \item{auth:}{A character string giving the file path to Theia credentials.
   Or a \code{\link{TheiaAuth}} object}
   \item{overwrite:}{Overwrite existing tiles (default to `FALSE`)}
   \item{bands:}{A character vector of bands to load from tiles}
   \item{out.file:}{Filename to store gdalcubes' image collection}
 }
}

\section{Details}{

   \code{TheiaCollection$new()} Create a new instance of the class

   \code{c$download(overwrite = FALSE, check = TRUE)} Download the tiles of the collection
   and check the resulting files

   \code{$ccheck()} Check the tiles of the collection

   \code{c$status} Return the status of each tile of the collection

   \code{c$extract(overwrite = FALSE, dest.dir = NULL)} Extract archives to
   dest.dir if supplied, or to the same directory as the archives otherwise

   \code{c$read(bands)} Read requested bands, apply corrections on values
   (as specified in Theia's product information), and return a list of
   RasterStack objects (one stack per tile)

   \code{c$as_gdalcube(out.file)} Create a `gdalcubes` image collection from
   downloaded tiles. See \url{https://github.com/appelmar/gdalcubes_R} for
   more details.
}

\examples{

\donttest{
# Create a collection from a query
## Create a query to Theia database, looking for tiles from Sentinel2
## satellite around Grenoble, between 2018-07-01 and 2018-07-06.

query <- list(collection = "SENTINEL2",
              town       = "Grenoble",
              start.date = "2018-07-01",
              end.date   = "2018-07-06")

## Create a collecion of tiles from this query
mycollection <- TheiaCollection$new(query = query, dir.path = ".")

print(mycollection)
}

# Alternatively, you can create a collection from a cart file (that you can
# download from Theia's website)
cart.path <- system.file("extdata", "cart.meta4", package = "theiaR")

mycollection <- TheiaCollection$new(cart.path = cart.path,
                                    dir.path  = ".")

print(mycollection)

\dontrun{
# Download the tiles in the collection
mycollection$download()
}

\dontrun{
# Finally, you can extract zip archives containing the tiles
mycollection$extract(overwrite = FALSE)
}

}
