% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-kernels.R
\name{mcmc_uncalibrated_langevin}
\alias{mcmc_uncalibrated_langevin}
\title{Runs one step of Uncalibrated Langevin discretized diffusion.}
\usage{
mcmc_uncalibrated_langevin(target_log_prob_fn, step_size,
  volatility_fn = NULL, parallel_iterations = 10,
  compute_acceptance = TRUE, seed = NULL, name = NULL)
}
\arguments{
\item{target_log_prob_fn}{Function which takes an argument like
\code{current_state} (if it's a list \code{current_state} will be unpacked) and returns its
(possibly unnormalized) log-density under the target distribution.}

\item{step_size}{\code{Tensor} or \code{list} of \code{Tensor}s representing the step
size for the leapfrog integrator. Must broadcast with the shape of
\code{current_state}. Larger step sizes lead to faster progress, but
too-large step sizes make rejection exponentially more likely. When
possible, it's often helpful to match per-variable step sizes to the
standard deviations of the target distribution in each variable.}

\item{volatility_fn}{function which takes an argument like
\code{current_state} (or \code{*current_state} if it's a list) and returns
volatility value at \code{current_state}. Should return a \code{Tensor} or
\code{list} of \code{Tensor}s that must broadcast with the shape of
\code{current_state}. Defaults to the identity function.}

\item{parallel_iterations}{the number of coordinates for which the gradients of
the volatility matrix \code{volatility_fn} can be computed in parallel.}

\item{compute_acceptance}{logical indicating whether to compute the
Metropolis log-acceptance ratio used to construct \code{MetropolisAdjustedLangevinAlgorithm} kernel.}

\item{seed}{integer to seed the random number generator.}

\item{name}{String prefixed to Ops created by this function.
Default value: \code{NULL} (i.e., 'mala_kernel').}
}
\value{
list of
\code{next_state} (Tensor or Python list of \code{Tensor}s representing the state(s)
of the Markov chain(s) at each result step. Has same shape as
and \code{current_state}.) and
\code{kernel_results} (\code{collections$namedtuple} of internal calculations used to
'advance the chain).
}
\description{
The class generates a Langevin proposal using \code{_euler_method} function and
also computes helper \code{UncalibratedLangevinKernelResults} for the next
iteration.
Warning: this kernel will not result in a chain which converges to the
\code{target_log_prob}. To get a convergent MCMC, use
\code{MetropolisAdjustedLangevinAlgorithm(...)} or \code{MetropolisHastings(UncalibratedLangevin(...))}.
}
\seealso{
Other mcmc_kernels: \code{\link{mcmc_dual_averaging_step_size_adaptation}},
  \code{\link{mcmc_hamiltonian_monte_carlo}},
  \code{\link{mcmc_metropolis_adjusted_langevin_algorithm}},
  \code{\link{mcmc_metropolis_hastings}},
  \code{\link{mcmc_no_u_turn_sampler}},
  \code{\link{mcmc_random_walk_metropolis}},
  \code{\link{mcmc_replica_exchange_mc}},
  \code{\link{mcmc_simple_step_size_adaptation}},
  \code{\link{mcmc_slice_sampler}},
  \code{\link{mcmc_transformed_transition_kernel}},
  \code{\link{mcmc_uncalibrated_hamiltonian_monte_carlo}},
  \code{\link{mcmc_uncalibrated_random_walk}}
}
\concept{mcmc_kernels}
