% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vi-functions.R
\name{vi_arithmetic_geometric}
\alias{vi_arithmetic_geometric}
\title{The Arithmetic-Geometric Csiszar-function in log-space}
\usage{
vi_arithmetic_geometric(logu, self_normalized = FALSE, name = NULL)
}
\arguments{
\item{logu}{\code{float}-like \code{Tensor} representing \code{log(u)} from above.}

\item{self_normalized}{\code{logical} indicating whether \verb{f'(u=1)=0}. When
\verb{f'(u=1)=0} the implied Csiszar f-Divergence remains non-negative even
when \verb{p, q} are unnormalized measures.}

\item{name}{name prefixed to Ops created by this function.}
}
\value{
arithmetic_geometric_of_u: \code{float}-like \code{Tensor} of the
Csiszar-function evaluated at \code{u = exp(logu)}.
}
\description{
A Csiszar-function is a member of \verb{F = \{ f:R_+ to R : f convex \}}.
}
\details{
When \code{self_normalized = True} the Arithmetic-Geometric Csiszar-function is:

\if{html}{\out{<div class="sourceCode">}}\preformatted{f(u) = (1 + u) log( (1 + u) / sqrt(u) ) - (1 + u) log(2)
}\if{html}{\out{</div>}}

When \code{self_normalized = False} the \verb{(1 + u) log(2)} term is omitted.

Observe that as an f-Divergence, this Csiszar-function implies:

\if{html}{\out{<div class="sourceCode">}}\preformatted{D_f[p, q] = KL[m, p] + KL[m, q]
m(x) = 0.5 p(x) + 0.5 q(x)
}\if{html}{\out{</div>}}

In a sense, this divergence is the "reverse" of the Jensen-Shannon
f-Divergence.
This Csiszar-function induces a symmetric f-Divergence, i.e.,
\code{D_f[p, q] = D_f[q, p]}.

Warning: when self_normalized = True\verb{this function makes non-log-space calculations and may therefore be numerically unstable for}|logu| >> 0`.
}
\seealso{
Other vi-functions: 
\code{\link{vi_amari_alpha}()},
\code{\link{vi_chi_square}()},
\code{\link{vi_csiszar_vimco}()},
\code{\link{vi_dual_csiszar_function}()},
\code{\link{vi_fit_surrogate_posterior}()},
\code{\link{vi_jeffreys}()},
\code{\link{vi_jensen_shannon}()},
\code{\link{vi_kl_forward}()},
\code{\link{vi_kl_reverse}()},
\code{\link{vi_log1p_abs}()},
\code{\link{vi_modified_gan}()},
\code{\link{vi_monte_carlo_variational_loss}()},
\code{\link{vi_pearson}()},
\code{\link{vi_squared_hellinger}()},
\code{\link{vi_symmetrized_csiszar_function}()}
}
\concept{vi-functions}
