% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe.R
\name{step_pretrained_text_embedding}
\alias{step_pretrained_text_embedding}
\title{Pretrained text-embeddings}
\usage{
step_pretrained_text_embedding(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  handle,
  args = NULL,
  skip = FALSE,
  id = recipes::rand_id("pretrained_text_embedding")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables.}

\item{role}{Role for the created variables}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{handle}{the Module handle to resolve.}

\item{args}{other arguments passed to [hub_load()].}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by [recipes::bake.recipe()]? While all operations are baked
when [recipes::prep.recipe()] is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using `skip = TRUE` as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}
}
\description{
`step_pretrained_text_embedding` creates a *specification* of a
 recipe step that will transform text data into its numerical
 transformation based on a pretrained model.
}
\examples{

\dontrun{
library(tibble)
library(recipes)
df <- tibble(text = c('hi', "heello", "goodbye"), y = 0)

rec <- recipe(y ~ text, df)
rec <- rec \%>\% step_pretrained_text_embedding(
 text,
 handle = "https://tfhub.dev/google/tf2-preview/gnews-swivel-20dim-with-oov/1"
)

}

}
