% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\name{get_global_step}
\alias{get_global_step}
\alias{set_global_step}
\title{Global step counters}
\usage{
get_global_step(increment = TRUE)

set_global_step(step)
}
\arguments{
\item{increment}{Wether to increment the \code{step} when getting it.}

\item{step}{New value for \code{step}.}
}
\value{
The global step value for the default logdir, when \code{get_global_step},
otherwise returns \code{NULL} invisibly.
}
\description{
Global step counters
}
\details{
\code{tfevents} tracks and automatically increased the step counter whenever
\code{\link[=log_event]{log_event()}} is called. Note that, it maintains a separate step counter for
each root \code{logdir}, thus if you change the \code{logdir} using \code{\link[=set_default_logdir]{set_default_logdir()}}
or \code{\link[=with_logdir]{with_logdir()}}, a different step counter will be used.
}
\section{Functions}{
\itemize{
\item \code{set_global_step()}: Set the global step.

}}
\examples{
temp <- tempfile()
with_logdir(temp, {
  print(get_global_step())
  set_global_step(100)
  print(get_global_step())
})
print(get_global_step())
}
