% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_map_and_batch}
\alias{dataset_map_and_batch}
\title{Fused implementation of dataset_map() and dataset_batch()}
\usage{
dataset_map_and_batch(
  dataset,
  map_func,
  batch_size,
  num_parallel_batches = NULL,
  drop_remainder = FALSE,
  num_parallel_calls = NULL
)
}
\arguments{
\item{dataset}{A dataset}

\item{map_func}{A function mapping a nested structure of tensors (having
shapes and types defined by \code{\link[=output_shapes]{output_shapes()}} and \code{\link[=output_types]{output_types()}} to
another nested structure of tensors. It also supports \code{purrr} style
lambda functions powered by \code{\link[rlang:as_function]{rlang::as_function()}}.}

\item{batch_size}{An integer, representing the number of consecutive elements
of this dataset to combine in a single batch.}

\item{num_parallel_batches}{(Optional) An integer, representing the number of batches
to create in parallel. On one hand, higher values can help mitigate the effect of
stragglers. On the other hand, higher values can increase contention if CPU is
scarce.}

\item{drop_remainder}{(Optional.) A boolean, representing whether the last
batch should be dropped in the case it has fewer than \code{batch_size}
elements; the default behavior is not to drop the smaller batch.}

\item{num_parallel_calls}{(Optional) An integer, representing the
number of elements to process in parallel If not specified, elements will
be processed sequentially.}
}
\description{
Maps `map_func`` across batch_size consecutive elements of this dataset and then combines
them into a batch. Functionally, it is equivalent to map followed by batch. However, by
fusing the two transformations together, the implementation can be more efficient.
}
\seealso{
Other dataset methods: 
\code{\link{dataset_batch}()},
\code{\link{dataset_cache}()},
\code{\link{dataset_collect}()},
\code{\link{dataset_concatenate}()},
\code{\link{dataset_decode_delim}()},
\code{\link{dataset_filter}()},
\code{\link{dataset_interleave}()},
\code{\link{dataset_map}()},
\code{\link{dataset_padded_batch}()},
\code{\link{dataset_prefetch_to_device}()},
\code{\link{dataset_prefetch}()},
\code{\link{dataset_reduce}()},
\code{\link{dataset_repeat}()},
\code{\link{dataset_shuffle_and_repeat}()},
\code{\link{dataset_shuffle}()},
\code{\link{dataset_skip}()},
\code{\link{dataset_take}()},
\code{\link{dataset_window}()}
}
\concept{dataset methods}
