% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loop_utilities.R
\name{loop_counter}
\alias{loop_counter}
\alias{base_name}
\alias{try_limit}
\title{Utilities for Looping to Read In Documents}
\usage{
loop_counter(i, total, file, ...)

base_name(path)

try_limit(
  expr,
  max.time = Inf,
  timeout.return = NULL,
  zero.length.return = "",
  silent = TRUE,
  ...
)
}
\arguments{
\item{i}{Iteration of the loop.}

\item{total}{Total number of iterations.}

\item{file}{The file name of that iteration to print out.}

\item{...}{ignored}

\item{path}{A character vector, containing path names.}

\item{expr}{An expression to run.}

\item{max.time}{Max allotted elapsed run time in seconds.}

\item{timeout.return}{Value to return for timeouts.}

\item{zero.length.return}{Value to return for length zero expression evaluations.}

\item{silent}{logical.  If \code{TRUE} report of error messages.}
}
\value{
\code{loop_counter} - Prints loop information.

\code{base_name} - Returns just the basename of the path.
}
\description{
\code{loop_counter} - A simple loop counter for tracking the progress of reading in
a batch of files.

\code{base_name} - Like \code{base::basename} but doesn't choke on long paths.

\code{try_limit} - Limits the amount of try that an expression can run for.  This
works to limit how long an attempted read-in of a document may take.  Most
useful in a loop with a few very long running document read-ins (e.g., .pdf
files that require \href{https://CRAN.R-project.org/package=tesseract}{\strong{tesseract} package}).
Note that \code{max.time} can not stop a \code{system} call (as many read-in functions
are essentially utilizing, but it can limit how many \code{system} calls are made.
This means a .pdf with multiple
\href{https://CRAN.R-project.org/package=tesseract}{\strong{tesseract}}) pages will only
allow the first page to read-in before returning an error result.  Note that
this approach does not distinguish between errors running the \code{expr} and
time-out errors.
}
\examples{
\dontrun{
files <- dir(
    system.file("docs", package = "textreadr"),
    full.names = TRUE, 
    recursive = TRUE, 
    pattern = '\\\\.(R?md|Rd?$|txt|sql|html|pdf|doc|ppt|tex)'
)

max_wait <- 30
total <- length(files)
content <- vector(mode = "list", total)

for (i in seq_along(files)){

    loop_counter(i, total, base_name(files[i]))

    content[[i]] <- try_limit(
        textreadr::read_document(files[i]), 
        max.time = max_wait, 
        zero.length.return = NA
    )
}


sapply(content, is.null)
sapply(content, function(x) length(x) == 1 && is.na(x))
content
}
}
