% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenizers.R
\name{tokenizers}
\alias{tokenizers}
\alias{word_tokenizer}
\alias{char_tokenizer}
\alias{space_tokenizer}
\title{Simple tokenization functions for string splitting}
\usage{
word_tokenizer(strings, ...)

char_tokenizer(strings, ...)

space_tokenizer(strings, sep = " ", xptr = FALSE, ...)
}
\arguments{
\item{strings}{\code{character} vector}

\item{...}{other parameters (usually not used - see source code for details).}

\item{sep}{\code{character}, \code{nchar(sep)} = 1 - split strings by this character.}

\item{xptr}{\code{logical} tokenize at C++ level - could speed-up by 15-50\%.}
}
\value{
\code{list} of \code{character} vectors. Each element of list contains vector of tokens.
}
\description{
Few simple tokenization functions. For more comprehensive list see \code{tokenizers} package:
\url{https://cran.r-project.org/package=tokenizers}.
Also check \code{stringi::stri_split_*}.
}
\examples{
doc = c("first  second", "bla, bla, blaa")
# split by words
word_tokenizer(doc)
#faster, but far less general - perform split by a fixed single whitespace symbol.
space_tokenizer(doc, " ")
}
