% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_2_textTrainRegression.R
\name{textTrainRegression}
\alias{textTrainRegression}
\title{Train word embeddings to a numeric variable.}
\usage{
textTrainRegression(
  x,
  y,
  outside_folds_v = 10,
  outside_strata_y = "y",
  inside_folds_prop = 3/4,
  inside_strata_y = "y",
  model = "regression",
  eval_measure = "default",
  preprocess_PCA = NA,
  penalty = 10^seq(-16, 16),
  mixture = c(0),
  Npredictors = NA,
  method_cor = "pearson",
  model_description = "Consider writing a description of your model here",
  multi_cores = "multi_cores_sys_default",
  save_output = "all",
  seed = 2020
)
}
\arguments{
\item{x}{Word embeddings from textEmbed (or textEmbedLayerAggregation).}

\item{y}{Numeric variable to predict.}

\item{outside_folds_v}{Number of folds for the outer folds (default = 10).}

\item{outside_strata_y}{Variable to stratify according (default y; can set to NULL).}

\item{inside_folds_prop}{Number of folds for the inner folds (default proportion = 3/4).}

\item{inside_strata_y}{Variable to stratify according (default y; can set to NULL).}

\item{model}{Type of model. Default is "regression"; see also "logistic" for classification.}

\item{eval_measure}{Type of evaluative measure to select models from; default =  "rmse" for regression and "bal_accuracy"
for logistic.}

\item{preprocess_PCA}{Pre-processing threshold for PCA (to skip this step set it to NA).
Can select amount of variance to retain (e.g., .90 or as a grid c(0.80, 0.90)); or
number of components to select (e.g., 10). Default is "min_halving", which is a function
that selects the number of PCA components based on number  of participants and feature (word embedding dimensions)
in the data. The formula is:
preprocess_PCA = round(max(min(number_features/2), number_participants/2), min(50, number_features))).}

\item{penalty}{hyper parameter that is tuned}

\item{mixture}{hyper parameter that is tuned default = 0 (hence a pure ridge regression).}

\item{Npredictors}{by efault this setting is turned of (i.e., NA). The setting uses  set to the highest number of predictors you want to test.
Then the X first dimensions are used in training, using a sequence from Kjell et al., 2019 paper in Psychological Methods.
Adding 1, then multiplying by 1.3 and finally rounding to the nearest integer (e.g., 1, 3, 5, 8).
This option is currently only possible for one embedding at the time.}

\item{method_cor}{Type of correlation used in evaluation (default "pearson";
can set to "spearman" or "kendall").}

\item{model_description}{Text to describe your model (optional; good when sharing the model with others).}

\item{multi_cores}{If TRUE it enables the use of multiple cores if the computer system allows for it (i.e., only on unix, not windows). Hence it
makes the analyses considerably faster to run. Default is "multi_cores_sys_default", where it automatically uses TRUE for Mac and Linux and FALSE for Windows.}

\item{save_output}{Option not to save all output; default "all". see also "only_results" and "only_results_predictions".}

\item{seed}{Set different seed.}
}
\value{
A (one-sided) correlation test between predicted and observed values; tibble of predicted values, as well as information
about the model (preprossing_recipe, final_model and model_description).
}
\description{
Train word embeddings to a numeric variable.
}
\examples{
\donttest{
wordembeddings <- wordembeddings4
ratings_data <- Language_based_assessment_data_8

results <- textTrainRegression(
  wordembeddings$harmonytext,
  ratings_data$hilstotal,
  multi_cores = FALSE # This is FALSE due to CRAN testing and Windows machines.
)
}
}
\seealso{
see \code{\link{textEmbedLayerAggregation}} \code{\link{textTrainLists}}
\code{\link{textTrainRandomForest}} \code{\link{textSimilarityTest}}
}
